//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : EEPROM.c
// Description: IAP 讀寫子程序
//Targer Board: None
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________
#include "common.h"


__16_type	gu16v_iap_add;
u8			gu8v_current_sn;
u8			gu8v_search_sn;

__byte_type	lu8a_iap_temp[10];
//user 地址
#define	C_Write_mod		0b10000000	//; select write program rom mode
#define	C_pg_erase_mod	0b10010100	//; select page erase mode	
#define	C_read_mod		0b10110000	//; select read program rom mode & set fden=1
#define	C_fwen_ctl_mod	0b01101000	//; select FWEN bit control mode & set FWPEN=1 

#define	C_EEPROM_Memory_addr_L_0	0x30
#define	C_EEPROM_Memory_addr_L_1	0x33

#define	EEPROM_IAP_DATA		0x30


//user0 user1的地址
#define	Lu16c_MemoryData0_addr	0x1B00
#define	Lu16c_MemoryData1_addr	0x1D40







//開辟IA空間
//const  u16	__attribute__((at(MemoryData0_addr))) MemoryData0[1152]={};


static volatile u8 SFR_FC0	__attribute__ ((at(0x143)));     //
static volatile u8 SFR_FC1	__attribute__ ((at(0x144)));     //
static volatile u8 SFR_FC2	__attribute__ ((at(0x145)));     //
//開辟IA空間
const	u16	__attribute__ ((at(IAP_START_ADDR))) Lu16c_MemoryData0[IAP_WRITE_TOTAL_LENGHT*IAP_USER_LENGHT]={};

void	EEPROM_READ_MEM_ADDR(u8	LU8V_IAP_USER_NUM);
void	EEPROM_WRITE_MEM_ADDR(u8	LU8V_IAP_USER_NUM);





//*************************************************************************************//
//function:	flash memory write enable
//Remark: 	
//*************************************************************************************//
u8 fun_enable_fwen(void)
{
	_emi = 0;
	_fc0 = ENABLE_FWEN_MODE;	//select FWEN (flash memory write enable) bit control mode 
	_fwpen = 1;			//start a 300us counter
	_fd1l = 0x00;		//write the correct data pattern into the Flash data registers during the counter
	_fd1h = 0x04;
	_fd2l = 0x0d;
	_fd2h = 0x09;
	_fd3l = 0xc3;
	_fd3h = 0x40;
	while(_fwpen)		//the devices will clear the FWPEN bit automatically
	{
		GCC_CLRWDT();
	}
	_emi = 1;	
	if(_cfwen)			//
	{
		return	1;
	}
	else
	{
		return	0;		//
	}
}


//*************************************************************************************//
//function:	read the data at the address:flash_addr
//Remark: 	  
//*************************************************************************************//
u16 fun_read_word(unsigned int flash_addr)
{
	u16	lu16v_return_read_word;
	_emi = 0;
	_fc0=READ_FLASH_MODE;	//select read flash rom mode
	_frden=1;	//Flash memory Read Enable Bit
	_farl=(unsigned char)(flash_addr&0xff);		//write data to Flash address register
	_farh=(unsigned char)((flash_addr>>8)&0xff);
	_frd=1;		//activate a read cycle
	while(_frd)
	{
		GCC_CLRWDT();
	}
	_frden=0;	
	//Flash memory Read Enable Bit
	lu16v_return_read_word = 0;
	lu16v_return_read_word = _fd0h; 
	lu16v_return_read_word = lu16v_return_read_word<< 8;
	lu16v_return_read_word+=_fd0l;	
	_emi = 1;	
	return	lu16v_return_read_word;
}


////*************************************************************************************//
////function:	read the data at the address:flash_addr
////Remark: 	读取一页的数据进行更新
////*************************************************************************************//
//void fun_read_page(	u16 flash_addr)
//{
//	
//	u8 i;
//	_emi = 0;
//	for(i=0;i<128;i++)
//	{
//		fun_read_word(flash_addr);
//		gu8v_data_buffer[i] = _fd0l;
//		i++;
//		gu8v_data_buffer[i] = _fd0h;
//		flash_addr++;		
//	}
//	_emi = 1;
//
//}


//*************************************************************************************//
//function:	erase the flash_addr' page 
//Remark: 	 
//*************************************************************************************//
void fun_erase_page(unsigned int flash_addr)
{
		u8	i;
	//如果寫實能成功則進行下一步
	if(	fun_enable_fwen())
	{
		_emi = 0;
		_fc0=PAGE_ERASE_MODE;						//select page erase mode
		_farl=(unsigned char)(flash_addr&0xff);		//write data to Flash address register
		_farh=(unsigned char)((flash_addr>>8)&0xff);
		
		for(i=0;i<32;i++)
		{
			_fd0h=0x00;				//標記地址
		}		
				
		_fwt=1;		//activate a write cycle
		while(_fwt)
		{
			GCC_CLRWDT();
		}
		_emi = 1;
	}	
}



//*************************************************************************************//
//function:	write page with the data:data_buffer[128]
//Remark: 	flash_addr should be the first address of a page
//*************************************************************************************//
void fun_write_data(unsigned int flash_addr,unsigned char flash_wlength,u8 *Lu8v_data)
{
	unsigned char i;
	//如果寫實能成功則進行下一步
	if(	fun_enable_fwen())
	{	
		_emi = 0;	
		_fc2=0x01;		//initiate clear Write Buffer process
		while(_clwb)
		{
			GCC_CLRWDT();
		}
		_fc0=WRITE_FLASH_MODE;	//select write flash rom mode
		_farl=(unsigned char)(flash_addr&0xff);		//write data to Flash address register
		_farh=(unsigned char)((flash_addr>>8)&0xff);
		for(i=0;i<flash_wlength;i++)	//write data to writer buffer
		{
			_fd0l = *Lu8v_data;
			i++;
			Lu8v_data++;
			_fd0h = *Lu8v_data;
			Lu8v_data++;		
		}
		_fwt=1;		//activate a write cycle
		while(_fwt)
		{
			GCC_CLRWDT();
		}
		_cfwen=0;	//disable the Flash write procedure
		_emi = 1;	
	}
}



/********************************************************************
Function:IAP_PAGE_ERASE
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	IAP_NEXT_MEM_DAAR(u8	LU8V_IAP_USER_NUM)
{
	u16 lu16v_iap_add_max;
	lu16v_iap_add_max = IAP_START_ADDR+(LU8V_IAP_USER_NUM+1)*IAP_WRITE_TOTAL_LENGHT;
	gu16v_iap_add.u16 += IAP_WRITE_WORD_LENGHT;
	if(gu16v_iap_add.u16>=lu16v_iap_add_max)
	{
		gu16v_iap_add.u16 = IAP_START_ADDR+LU8V_IAP_USER_NUM*IAP_WRITE_TOTAL_LENGHT;
	
	}

}

/********************************************************************
Function:IAP_Previous_Mem_Addr
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	IAP_Previous_Mem_Addr(u8	LU8V_IAP_USER_NUM)
{
	u16 lu16v_iap_add_min;
	lu16v_iap_add_min = IAP_START_ADDR+LU8V_IAP_USER_NUM*IAP_WRITE_TOTAL_LENGHT;
	gu16v_iap_add.u16 -= 4;
	if(gu16v_iap_add.u16 < lu16v_iap_add_min)
	{
		//如果小於最小值則將下一筆數據地址返回至最後一個位置
		gu16v_iap_add.u16 = IAP_START_ADDR+(LU8V_IAP_USER_NUM+1)*IAP_WRITE_TOTAL_LENGHT-IAP_WRITE_WORD_LENGHT;
	}
}
//;****************************************************************
//;IAP format(4 words)
//;sys_L	--收缩压
//;dia_H & sys_H(bit7~0)	
//;dia_L	--舒张压
//;pulse
//;min;;bit7=0 am/bit7=1 pm OR hour.4
//;bit7--bit4 month/bit3--bit0 hour
//;day
//;year
//;****************************************************************
u8	IAP_READ_MEN_DATA(u8 *Lu8a_IAP_Buff)
{
	__16_type TABLE_BUFF;


	TABLE_BUFF.u16 = Lu16c_MemoryData0[gu16v_iap_add.u16 - IAP_START_ADDR];
	*(Lu8a_IAP_Buff+0) = TABLE_BUFF.byte.byte0;
	*(Lu8a_IAP_Buff+1) = TABLE_BUFF.byte.byte1&0x0f;
	*(Lu8a_IAP_Buff+3) = (TABLE_BUFF.byte.byte1>>4)&0x0f;
	
	
	gu16v_iap_add.u16++;
	TABLE_BUFF.u16 = Lu16c_MemoryData0[gu16v_iap_add.u16 - IAP_START_ADDR];
	*(Lu8a_IAP_Buff+2) = TABLE_BUFF.byte.byte0;
	*(Lu8a_IAP_Buff+4) = TABLE_BUFF.byte.byte1;	
	
	gu16v_iap_add.u16++;
	TABLE_BUFF.u16 = Lu16c_MemoryData0[gu16v_iap_add.u16 - IAP_START_ADDR];
	*(Lu8a_IAP_Buff+5) = TABLE_BUFF.byte.byte0;	
	*(Lu8a_IAP_Buff+6) = TABLE_BUFF.byte.byte1&0x0f;
	if(*(Lu8a_IAP_Buff+5)&0x80)
	{
		*(Lu8a_IAP_Buff+6) |= 0x10; 	
		*(Lu8a_IAP_Buff+5) &= 0x80;	
	}

	*(Lu8a_IAP_Buff+8) = (TABLE_BUFF.byte.byte1>>4)&0x0f;//;month
	gu16v_iap_add.u16++;
	TABLE_BUFF.u16 = Lu16c_MemoryData0[gu16v_iap_add.u16 - IAP_START_ADDR];	
	*(Lu8a_IAP_Buff+7) = TABLE_BUFF.byte.byte0;
	*(Lu8a_IAP_Buff+9) = TABLE_BUFF.byte.byte1;

	gu16v_iap_add.u16 -= 3;	

	if(*(Lu8a_IAP_Buff+0)==0 && *(Lu8a_IAP_Buff+1)==0)
	{
		return	0;	
	}
	if(*(Lu8a_IAP_Buff+2)==0 && *(Lu8a_IAP_Buff+3)==0)
	{
		return	0;	
	}	
	if(*(Lu8a_IAP_Buff+4))
	{
		return	0xff;
	}
	return	0;
}

/********************************************************************
Function:EEPROM_READ_MEM_ADDR
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	EEPROM_READ_MEM_ADDR(u8	LU8V_IAP_USER_NUM)
{
	u8	lu8v_eeprom_addr;
	lu8v_eeprom_addr = EEPROM_IAP_DATA + LU8V_IAP_USER_NUM*3;
	gu16v_iap_add.byte.byte0=fun_Read_EEPROM(lu8v_eeprom_addr);
	lu8v_eeprom_addr ++;
	gu16v_iap_add.byte.byte1=fun_Read_EEPROM(lu8v_eeprom_addr);	
	lu8v_eeprom_addr ++;
	gu8v_current_sn=fun_Read_EEPROM(lu8v_eeprom_addr);
	
	//判斷IAP地址是否有超出範圍
	if(gu16v_iap_add.u16<(IAP_START_ADDR+LU8V_IAP_USER_NUM*IAP_WRITE_TOTAL_LENGHT)||
	   gu16v_iap_add.u16>=(IAP_START_ADDR+(LU8V_IAP_USER_NUM+1)*IAP_WRITE_TOTAL_LENGHT))
	{
	   	gu16v_iap_add.u16 = (IAP_START_ADDR+LU8V_IAP_USER_NUM*IAP_WRITE_TOTAL_LENGHT);
	   	gu8v_current_sn = 01;
	   	//如果數據出錯從第一組數據開始保存，擦除PAGE1
	   	fun_erase_page(IAP_START_ADDR+LU8V_IAP_USER_NUM*IAP_WRITE_TOTAL_LENGHT);
	   	EEPROM_WRITE_MEM_ADDR(LU8V_IAP_USER_NUM);
	}
	
	

}

/********************************************************************
Function:EEPROM_READ_MEM_ADDR
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	EEPROM_WRITE_MEM_ADDR(u8	LU8V_IAP_USER_NUM)
{
	u8	lu8v_eeprom_addr;
	lu8v_eeprom_addr = EEPROM_IAP_DATA + LU8V_IAP_USER_NUM*3;	
	fun_Write_EEPROM(lu8v_eeprom_addr,gu16v_iap_add.byte.byte0);
	lu8v_eeprom_addr ++;
	fun_Write_EEPROM(lu8v_eeprom_addr,gu16v_iap_add.byte.byte1);	
	lu8v_eeprom_addr ++;
	fun_Write_EEPROM(lu8v_eeprom_addr,gu8v_current_sn);	
}
/********************************************************************
Function:IAP_WRITE_TEST
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	IAP_WRITE_TEST()
{
//	volatile	u8	Lu8a_IAP_Buff[8],i;
//	
//	for(i=0;i<8;i++)
//	{
//		Lu8a_IAP_Buff[i] = i;
//	}
//	//******************************************//
//	//一次IAP的寫動作
//	IAP_WRITE_FLASH_ENABLE();
//	IAP_WRITE_FLASH_MODE((__16_type)(Lu16c_MemoryData0_addr));
//	IAP_WRITE_FLASH_BUFFER(8,*Lu8a_IAP_Buff);
//	IAP_WRITE_FLASH();
//	for(i=0;i<8;i++)
//	{
//		Lu8a_IAP_Buff[i] = 0;
//	}
//	
//	
//	//讀IAP的寫動作
//	for(i=0;i<8;i++)
//	{
//		Lu8a_IAP_Buff[i] = Lu16c_MemoryData0[i];		
//	}
//	GCC_NOP();
//
//
//	//******************************************//
//	//一次IAP的擦除動作		
//	IAP_WRITE_FLASH_ENABLE();
//	IAP_WRITE_FLASH_MODE((__16_type)(Lu16c_MemoryData0_addr));
//	IAP_PAGE_ERASE();	
//	//******************************************//	
//	GCC_NOP();	
}
/********************************************************************
Function:IAP_SAVE_MEMORY
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	IAP_SAVE_MEMORY(u8	LU8V_IAP_USER_NUM)
{

//	volatile 	__byte_type	lu8a_iap_temp[8];
	//建議開始存數據時關閉中斷
	//	_emi = 0;
	//讀取EEprom內容
	gu16v_iap_add.u16= 	Lu16c_MemoryData0[0];
	EEPROM_READ_MEM_ADDR(LU8V_IAP_USER_NUM);
	//_PRE_SYS&_PRE_DIA組合成 3 byte
	lu8a_iap_temp[0].u8 = gu16v_sys%256;
	lu8a_iap_temp[2].u8 = gu16v_dia%256;

	lu8a_iap_temp[1].u8 = gu16v_sys/256 & 0x0f;
	lu8a_iap_temp[1].u8 |= (gu16v_dia/256 & 0x0f)<<4;	
	//
	lu8a_iap_temp[3].u8 = gu8v_heart;
	//
	lu8a_iap_temp[4].u8 = gu8t_time_minute & 0b00111111;
	//小時
	lu8a_iap_temp[5].u8 = gu8t_time_hour & 0x0f;
	//小時
	if((gu8t_time_hour & 0b00010000) !=0)
	{
		lu8a_iap_temp[4].bits.b7 = 1;
	}
	//天數
	lu8a_iap_temp[6].u8 = gu8t_time_day;
	//月份
	lu8a_iap_temp[5].u8 |= (gu8t_time_month&0x0f)<<4;
	//年份		
	lu8a_iap_temp[7].u8 = gu8t_time_year;
	
	//******************************************//
	//一次IAP的寫動作
	fun_write_data(gu16v_iap_add.u16,IAP_WRITE_BYTE_LENGHT,(u8*)lu8a_iap_temp);	
	//Next Record，執行完寫動作后將當前指針指向下一個空地址
	IAP_NEXT_MEM_DAAR(LU8V_IAP_USER_NUM);
	//如果寫完一頁則擦除下一頁
	if((gu16v_iap_add.byte.byte0 & 0b00111111)==0)
	{
		//一次IAP的擦除動作		
		fun_erase_page(gu16v_iap_add.u16);		
			
	}
	
	//指針累加加到最后一組
	gu8v_current_sn ++;
	if(gu8v_current_sn>=IAP_SAVE_TOTAL_LENGHT+1)
	{
		gu8v_current_sn = IAP_SAVE_TOTAL_LENGHT+1;
	}
	gu8v_search_sn = gu8v_current_sn;	
	
	EEPROM_WRITE_MEM_ADDR(LU8V_IAP_USER_NUM);
}




/********************************************************************
Function:IAP_READ_MEMORY
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	IAP_READ_MEMORY_3_AEG(u8	LU8V_IAP_USER_NUM)
{
//	volatile u8	lu8v_iap_temp_buff[10],
	u8	i,lu8v_avg_count;
	__16_type	lu16v_dia_data,lu16v_sys_data,lu16v_heart;
	//取第一筆數據
	EEPROM_READ_MEM_ADDR(LU8V_IAP_USER_NUM);
	IAP_Previous_Mem_Addr(LU8V_IAP_USER_NUM);
	lu16v_dia_data.u16 = 0;
	lu16v_sys_data.u16 = 0;
	lu16v_heart.u16 = 0;	
	if(gu8v_current_sn-1>3)
	{
		lu8v_avg_count = 3;
	}
	else
	{
		lu8v_avg_count = gu8v_current_sn-1;		
	}
	
	for(i=0;i<lu8v_avg_count;i++)
	{
		IAP_READ_MEN_DATA((u8*)lu8a_iap_temp);
		IAP_Previous_Mem_Addr(LU8V_IAP_USER_NUM);
		lu16v_dia_data.u16 += (u16)lu8a_iap_temp[1].u8*256+lu8a_iap_temp[0].u8;
		lu16v_sys_data.u16 += (u16)lu8a_iap_temp[3].u8*256+lu8a_iap_temp[2].u8;	
		lu16v_heart.u16 += lu8a_iap_temp[4].u8;	
	}

	lu16v_dia_data.u16 /= i;
	lu8a_iap_temp[1].u8 = lu16v_dia_data.byte.byte1;
	lu8a_iap_temp[0].u8 = lu16v_dia_data.byte.byte0; 	
	lu16v_sys_data.u16 /= i;
	lu8a_iap_temp[3].u8 = lu16v_sys_data.byte.byte1;
	lu8a_iap_temp[2].u8 = lu16v_sys_data.byte.byte0;	
	lu8a_iap_temp[4].u8 = lu16v_heart.u16 /i;


}	

/********************************************************************
Function:IAP_READ_MEMORY
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	IAP_READ_MEMORY(u8	LU8V_IAP_USER_NUM,u8 lu8v_iap_search_num)
{
	//volatile u8	lu8v_iap_temp_buff[10];
//	u8	i;	
//	u16	lu16v_dia_data,lu16v_sys_data;	
	//取第一筆數據
	EEPROM_READ_MEM_ADDR(LU8V_IAP_USER_NUM);
//	IAP_Previous_Mem_Addr(LU8V_IAP_USER_NUM);
	if(gu8v_current_sn<=1)
	{
		
	}
	else
	{
		//假如查詢的位置小於最小位置
		if(	(gu16v_iap_add.u16-lu8v_iap_search_num*IAP_WRITE_WORD_LENGHT)
		     <IAP_START_ADDR+LU8V_IAP_USER_NUM*IAP_WRITE_TOTAL_LENGHT)
		{
			gu16v_iap_add.u16 += IAP_WRITE_TOTAL_LENGHT-lu8v_iap_search_num*IAP_WRITE_WORD_LENGHT;
			
			
		}
		else
		{
			
			gu16v_iap_add.u16 -= lu8v_iap_search_num*IAP_WRITE_WORD_LENGHT;
		}
		IAP_READ_MEN_DATA((u8*)lu8a_iap_temp);		
		
	}	

	
	
	
}	

/********************************************************************
Function:IAP_READ_MEMORY
INPUT	:
OUTPUT	:
NOTE	:none
*******************************************************************/
void	IAP_ERASE_MEMORY(u8	LU8V_IAP_USER_NUM)
{
	//volatile u8	lu8v_iap_temp_buff[10];
	u8	i;	
	for(i=0;i<IAP_WRITE_PAGE_LENGHT;i++)
	{
		//擦除當前page
		fun_erase_page(IAP_START_ADDR+LU8V_IAP_USER_NUM*IAP_WRITE_TOTAL_LENGHT+i*IAP_PAGE_LENGHT);
		
	}
	gu16v_iap_add.u16 = (IAP_START_ADDR+LU8V_IAP_USER_NUM*IAP_WRITE_TOTAL_LENGHT);
	gu8v_current_sn = 01;
	//如果數據出錯從第一組數據開始保存，擦除PAGE1
  	EEPROM_WRITE_MEM_ADDR(LU8V_IAP_USER_NUM);	
}	